<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Forms;

class CorrectAnswers extends \Google\Collection
{
  protected $collection_key = 'answers';
  protected $answersType = CorrectAnswer::class;
  protected $answersDataType = 'array';

  /**
   * A list of correct answers. A quiz response can be automatically graded
   * based on these answers. For single-valued questions, a response is marked
   * correct if it matches any value in this list (in other words, multiple
   * correct answers are possible). For multiple-valued (`CHECKBOX`) questions,
   * a response is marked correct if it contains exactly the values in this
   * list.
   *
   * @param CorrectAnswer[] $answers
   */
  public function setAnswers($answers)
  {
    $this->answers = $answers;
  }
  /**
   * @return CorrectAnswer[]
   */
  public function getAnswers()
  {
    return $this->answers;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(CorrectAnswers::class, 'Google_Service_Forms_CorrectAnswers');
