<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\SecurityCommandCenter;

class GoogleCloudSecuritycenterV1CustomConfig extends \Google\Model
{
  /**
   * Unspecified severity.
   */
  public const SEVERITY_SEVERITY_UNSPECIFIED = 'SEVERITY_UNSPECIFIED';
  /**
   * Critical severity.
   */
  public const SEVERITY_CRITICAL = 'CRITICAL';
  /**
   * High severity.
   */
  public const SEVERITY_HIGH = 'HIGH';
  /**
   * Medium severity.
   */
  public const SEVERITY_MEDIUM = 'MEDIUM';
  /**
   * Low severity.
   */
  public const SEVERITY_LOW = 'LOW';
  protected $customOutputType = GoogleCloudSecuritycenterV1CustomOutputSpec::class;
  protected $customOutputDataType = '';
  /**
   * Text that describes the vulnerability or misconfiguration that the custom
   * module detects. This explanation is returned with each finding instance to
   * help investigators understand the detected issue. The text must be enclosed
   * in quotation marks.
   *
   * @var string
   */
  public $description;
  protected $predicateType = Expr::class;
  protected $predicateDataType = '';
  /**
   * An explanation of the recommended steps that security teams can take to
   * resolve the detected issue. This explanation is returned with each finding
   * generated by this module in the `nextSteps` property of the finding JSON.
   *
   * @var string
   */
  public $recommendation;
  protected $resourceSelectorType = GoogleCloudSecuritycenterV1ResourceSelector::class;
  protected $resourceSelectorDataType = '';
  /**
   * The severity to assign to findings generated by the module.
   *
   * @var string
   */
  public $severity;

  /**
   * Custom output properties.
   *
   * @param GoogleCloudSecuritycenterV1CustomOutputSpec $customOutput
   */
  public function setCustomOutput(GoogleCloudSecuritycenterV1CustomOutputSpec $customOutput)
  {
    $this->customOutput = $customOutput;
  }
  /**
   * @return GoogleCloudSecuritycenterV1CustomOutputSpec
   */
  public function getCustomOutput()
  {
    return $this->customOutput;
  }
  /**
   * Text that describes the vulnerability or misconfiguration that the custom
   * module detects. This explanation is returned with each finding instance to
   * help investigators understand the detected issue. The text must be enclosed
   * in quotation marks.
   *
   * @param string $description
   */
  public function setDescription($description)
  {
    $this->description = $description;
  }
  /**
   * @return string
   */
  public function getDescription()
  {
    return $this->description;
  }
  /**
   * The CEL expression to evaluate to produce findings. When the expression
   * evaluates to true against a resource, a finding is generated.
   *
   * @param Expr $predicate
   */
  public function setPredicate(Expr $predicate)
  {
    $this->predicate = $predicate;
  }
  /**
   * @return Expr
   */
  public function getPredicate()
  {
    return $this->predicate;
  }
  /**
   * An explanation of the recommended steps that security teams can take to
   * resolve the detected issue. This explanation is returned with each finding
   * generated by this module in the `nextSteps` property of the finding JSON.
   *
   * @param string $recommendation
   */
  public function setRecommendation($recommendation)
  {
    $this->recommendation = $recommendation;
  }
  /**
   * @return string
   */
  public function getRecommendation()
  {
    return $this->recommendation;
  }
  /**
   * The resource types that the custom module operates on. Each custom module
   * can specify up to 5 resource types.
   *
   * @param GoogleCloudSecuritycenterV1ResourceSelector $resourceSelector
   */
  public function setResourceSelector(GoogleCloudSecuritycenterV1ResourceSelector $resourceSelector)
  {
    $this->resourceSelector = $resourceSelector;
  }
  /**
   * @return GoogleCloudSecuritycenterV1ResourceSelector
   */
  public function getResourceSelector()
  {
    return $this->resourceSelector;
  }
  /**
   * The severity to assign to findings generated by the module.
   *
   * Accepted values: SEVERITY_UNSPECIFIED, CRITICAL, HIGH, MEDIUM, LOW
   *
   * @param self::SEVERITY_* $severity
   */
  public function setSeverity($severity)
  {
    $this->severity = $severity;
  }
  /**
   * @return self::SEVERITY_*
   */
  public function getSeverity()
  {
    return $this->severity;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudSecuritycenterV1CustomConfig::class, 'Google_Service_SecurityCommandCenter_GoogleCloudSecuritycenterV1CustomConfig');
